<?php
// Inclusions des fichiers de configuration, de connexion à la base de données et des fonctions
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("func/compte_inc.php");
include("inc/top.php");
include("inc/bottom.php");

// Démarrage de la session et vérification de l'authentification de l'utilisateur
session_start();
if(!isset($_SESSION['iduser'])){
    header("Location:connecter.php");
    exit;
}

// Définition des variables utilisées dans la vue
$USER = isset($_SESSION['username']) ? $_SESSION['username'] : 'guest';

// Début de la partie HTML (la vue)
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Mon compte</title>
</head>
<body>
<div class="well well-small">
    <h3>Mon compte</h3>
    <hr class="soften"/>

    <div class="row-fluid">
        <ul class="thumbnails">
            <li class="span4">
                <div class="thumbnail">
                    <a href="mesinfos.php">
                        <img src="http://localhost/breizhsecu/images/comptes/<?php echo htmlspecialchars($USER); ?>.jpg" alt="">
                    </a>
                    <div class="caption">
                        <a href="mesinfos.php"><h5>Mes infos</h5></a>
                    </div>
                </div>
            </li>
            <li class="span4">
                <div class="thumbnail">
                    <a href="mescommandes.php">
                        <img src="images/divers/commandes.jpg" alt=""/>
                    </a>
                    <div class="caption">
                        <a href="mescommandes.php"><h5>Mes commandes</h5></a>
                    </div>
                </div>
            </li>
            <li class="span4">
                <div class="thumbnail">
                    <a href="avis.php">
                        <img src="images/divers/avis.jpg" alt=""/>
                    </a>
                    <div class="caption">
                        <a href="avis.php"><h5>Mes avis</h5></a>
                    </div>
                </div>
            </li>
        </ul>
    </div>
</div>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->

</body>
</html>
