<?php
// Démarrage de la session et inclusion des fichiers nécessaires en haut du fichier
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("inc/top.php");

// Traitement PHP ici...
// Par exemple, gestion de la suppression des avis
if(isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $idavis = intval($_GET['delete']);
    $stmt = $bdd->prepare("DELETE FROM avis WHERE idavis = ?");
    $stmt->execute([$idavis]);
}

// Préparation de la requête SQL pour récupérer les avis de l'utilisateur
$idcompte = isset($_SESSION['iduser']) ? intval($_SESSION['iduser']) : 0;
$stmt = $bdd->prepare("SELECT idavis, produit.idproduit, produit.titre, produit.description, produit.prix, avis.titre as titreavis, avis.texte as texteavis FROM avis JOIN produit ON avis.idproduit = produit.idproduit WHERE idcompte = ?");
$stmt->execute([$idcompte]);
$avis = $stmt->fetchAll();

// Ensuite, passage à la partie HTML...
?>
<div class="well well-small">
    <h1>Mes avis</h1>
    <hr class="soften"/>

    <table class="table table-bordered table-condensed">
        <thead>
            <tr>
                <th width="80">Produit</th>
                <th>Avis</th>
                <th width="80">&nbsp;</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($avis as $donnee): ?>
                <tr>
                    <td><img width="100" src="images/<?php echo htmlspecialchars($donnee['idproduit']); ?>.jpg" alt=""><br/></td>
                    <td><b><?php echo htmlspecialchars($donnee['titreavis']); ?></b><br><?php echo htmlspecialchars($donnee['texteavis']); ?></td>
                    <td><a class="defaultBtn" href="avis.php?delete=<?php echo htmlspecialchars($donnee['idavis']); ?>" title="Cliquez pour supprimer">Supprimer</a></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <br/>

    <a href="mescommandes.php" class="shopBtn btn-large"><span class="icon-arrow-left"></span> Retour à la liste de mes commandes </a>
</div>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->
