<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("inc/top.php");
include("inc/bottom.php");

// Initialiser le panier si nécessaire
if (!isset($_SESSION['PANIER'])) {
    $_SESSION['PANIER'] = "";
}

// Ajouter un produit au panier
if (isset($_GET['add']) && isset($_GET['id'])) {
    $_SESSION['PANIER'] .= $_GET['id'] . ";";
}

// Ajouter une unité supplémentaire d'un produit au panier
if (isset($_GET['ajj'])) {
    $_SESSION['PANIER'] .= $_GET['ajj'] . ";";
}

// Supprimer une unité d'un produit du panier
if (isset($_GET['sub'])) {
    ajusterQuantite($_GET['sub'], -1);
}

// Supprimer complètement un produit du panier
if (isset($_GET['remove'])) {
    retirerProduit($_GET['remove']);
}

// Fonctions pour la manipulation du panier
function ajusterQuantite($idProduit, $delta) {
    $panierArray = explode(";", trim($_SESSION['PANIER'], ";"));
    if ($delta < 0) {
        $key = array_search($idProduit, $panierArray);
        if ($key !== false) {
            unset($panierArray[$key]);
        }
    } else {
        $panierArray[] = $idProduit;
    }
    $_SESSION['PANIER'] = implode(";", $panierArray) . ";";
}

function retirerProduit($idProduit) {
    $panierArray = explode(";", trim($_SESSION['PANIER'], ";"));
    $panierArray = array_filter($panierArray, function ($item) use ($idProduit) {
        return $item != $idProduit;
    });
    $_SESSION['PANIER'] = implode(";", $panierArray) . ";";
}


$panierrempli = getDetailsPanier($bdd, $_SESSION['PANIER']);
$montanttotal = 0;
?>
<!-- HTML pour afficher le panier -->
<div class="well well-small">
    <h1>Panier <small class="pull-right"> <?php echo count($panierrempli); ?> Article(s) dans votre panier </small></h1>
    <hr class="soften"/>
    <table class="table table-bordered table-condensed">
        <thead>
            <tr>
                <th>Produit</th>
                <th>Description</th>
                <th>Ref.</th>
                <th>Prix Unitaire</th>
                <th>Qté</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($panierrempli as $idprod => $qte): ?>
                <?php $produit = getProduct($bdd, $idprod); ?>
                <tr>
                    <td><img width="100" src="images/<?php echo $idprod; ?>.jpg" alt=""></td>
                    <td><b><?php echo $produit['titre']; ?></b><br><?php echo $produit['description']; ?></td>
                    <td>000<?php echo $idprod; ?></td>
                    <td><?php echo $produit['prix']; ?> &euro;</td>
                    <td><?php echo $qte; ?></td>
                    <td><?php echo $produit['prix'] * $qte; ?> &euro;</td>
                </tr>
                <?php $montanttotal += $produit['prix'] * $qte; ?>
            <?php endforeach; ?>
            <tr>
                <td colspan="5" class="alignR">Total:</td>
                <td class="label label-primary"> <?php echo $montanttotal; ?> &euro;</td>
            </tr>
        </tbody>
    </table><br/>

    <a href="index.php" class="shopBtn btn-large"><span class="icon-arrow-left"></span> Continuez à visiter </a>
    <?php if(count($panierrempli) > 0): ?>
      <a href="payer.php" class="shopBtn btn-large pull-right">Payer <span class="icon-arrow-right"></span></a>
    <?php endif; ?>
</div>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->

