<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/produit_inc.php");
include("func/panier_inc.php");

// Vérification de l'authentification de l'utilisateur
if (!isset($_SESSION['iduser'])) {
    header("Location: connecter.php");
    exit; // Assure que le script ne continue pas après une redirection
} else {
    // Récupération du panier de l'utilisateur
    $panierrempli = getPanier(); // Supposons que cette fonction retourne un tableau associatif idProduit => quantité

    // Utilisation d'une transaction pour s'assurer de l'intégrité des données
    try {
        $bdd->beginTransaction();
        
        $stmt = $bdd->prepare("INSERT INTO commande (iduser, date, statut) VALUES (?, ?, 'En attente de paiement')");
        $stmt->execute([$_SESSION['iduser'], date('Y-m-d')]);
        $idcde = $bdd->lastInsertId();

        if ($idcde) {
            foreach ($panierrempli as $idprod => $qte) {
                $stmt = $bdd->prepare("INSERT INTO detailcommande (idcde, idproduit, quantite) VALUES (?, ?, ?)");
                $stmt->execute([$idcde, $idprod, $qte]);
            }

            $bdd->commit(); // Valider la transaction
            header("Location: cb.php?commande=" . $idcde);
            exit;
        }
    } catch (Exception $e) {
        $bdd->rollBack(); // Annuler la transaction en cas d'erreur
        echo "Erreur : " . $e->getMessage();
    }
}
?>
