<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("func/avis_inc.php");
include("inc/bottom.php");
include("inc/top.php");

// Vérification de la soumission de l'avis
if(isset($_GET['poster']) && isset($_SESSION['iduser']) && !empty($_GET['titreavis']) && !empty($_GET['texteavis']) && isset($_GET['id'])){
    // Préparation de la requête pour éviter les injections SQL
    $stmt = $bdd->prepare("INSERT INTO avis (iduser, idproduit, date, titreavis, texteavis) VALUES (?, ?, NOW(), ?, ?)");
    $stmt->execute([$_SESSION['iduser'], $_GET['id'], $_GET['titreavis'], $_GET['texteavis']]);
}


// Récupération du produit
if(isset($_GET['id'])) {
    $produit = getProduct($bdd, $_GET['id']);
}

if (!isset($produit)) {
    echo "Produit non trouvé";
    include("inc/bottom.php");
    exit;
}
?>
<div class="row-fluid">
    <div class="span5">
        <!-- Carousel et image du produit -->
        <div id="myCarousel" class="carousel slide cntr">
            <div class="carousel-inner">
                <div class="item active">
                    <a href="#"> <img src="images/<?php echo $produit['idproduit']; ?>.jpg" alt="" style="width:100%"></a>
                </div>
            </div>
            <a class="left carousel-control" href="#myCarousel" data-slide="prev">‹</a>
            <a class="right carousel-control" href="#myCarousel" data-slide="next">›</a>
        </div>
    </div>
    <div class="span7">
        <h3><?php echo htmlspecialchars($produit['titre']); ?></h3>
        <hr class="soft"/>
        <!-- Description et prix du produit -->
        <form class="form-horizontal qtyFrm" action="panier.php" method="get">
            <input type="hidden" name="add" />
            <input type="hidden" name="id" value="<?php echo $produit['idproduit']; ?>" />
            <div class="control-group">
                <label class="control-label"><span><?php echo htmlspecialchars($produit['prix']); ?> &euro;</span></label>
            </div>
            <p><?php echo htmlspecialchars($produit['description']); ?></p>
            <button type="submit" class="shopBtn"><span class="icon-shopping-cart"></span> Ajouter au panier</button>
        </form>
    </div>
</div>
<hr class="softn clr"/>

<!-- Détails et avis sur le produit -->
<div id="productDetail" class="nav nav-tabs">
    <ul>
        <li class=""><a href="#home" data-toggle="tab">Détails</a></li>
        <li class="active"><a href="#profile" data-toggle="tab">Avis</a></li>
    </ul>
</div>
<div id="myTabContent" class="tab-content tabWrapper">
    <div class="tab-pane fade" id="home">
        <h4>Informations</h4>
        <!-- Plus d'informations ici -->
    </div>
    <div class="tab-pane fade active in" id="profile">
        <?php getAvis($bdd, $produit['idproduit']); ?>
        <!-- Formulaire pour poster un avis -->
        <form class="form-horizontal qtyFrm" action="product_details.php" method="get">
            <div class="row-fluid">
                <div class="span2">
                    &nbsp;<br/><img src="images/divers/anonyme.jpg" alt=""><input type="hidden" name="id" value="<?php echo $produit['idproduit']; ?>"/>
                </div>
                <div class="span6">
                    <h5>Votre avis</h5>
                    <input type="text" name="titreavis" placeholder="Titre de votre avis"/>
                    <textarea name="texteavis"></textarea>
                </div>
                <div class="span4 alignR">
					<div class="btn-group">
						<button type="submit" class="defaultBtn" name="poster"><span class="icon-pencil"></span> Poster</button>
					</div>
				</div>
			</div>
		</form>
	</div>
</div>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->

