<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/produit_inc.php");
include("func/panier_inc.php");

// Définis une liste de pages vers lesquelles les redirections sont autorisées
$pagesAutorisees = ['acquittement.php', 'erreur.php', 'confirmation.php'];

// Vérifie si la direction est dans la liste des pages autorisées
if (isset($_GET['direction']) && in_array($_GET['direction'], $pagesAutorisees) && isset($_GET['commande']) && ctype_digit($_GET['commande'])) {
    // Si oui, procède à la redirection
    header("Location: " . htmlspecialchars($_GET['direction']) . "?commande=" . htmlspecialchars($_GET['commande']));
    exit; // Assure que le reste du script ne s'exécute pas après la redirection
} else {
    // Si non, redirige vers une page d'erreur ou page par défaut
    header("Location: erreur.php");
    exit;
}
?>
