<?php
// Démarrage de la session
session_start();

// Inclusions des fichiers nécessaires
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/produit_inc.php");
include("func/panier_inc.php");

// Définition de la fonction de validation
function isValid($cb, $validite, $crypto) {
    // Vérification des informations de la carte
    if ($cb == "1234123412341234" && $validite == "01/24" && $crypto == "123") {
        return true;
    } else {
        return false;
    }
}

// Redirection si l'utilisateur n'est pas connecté
if (!isset($_SESSION['iduser'])) {
    header("Location: connecter.php");
    exit;
}

// Nettoyage et validation des données d'entrée pour prévenir les failles de sécurité
$cb = isset($_GET['cb']) ? htmlspecialchars($_GET['cb']) : '';
$validite = isset($_GET['validite']) ? htmlspecialchars($_GET['validite']) : '';
$crypto = isset($_GET['crypto']) ? htmlspecialchars($_GET['crypto']) : '';
$commande = isset($_GET['commande']) ? intval($_GET['commande']) : 0; // Converti en entier pour plus de sécurité

// Vérification de la validité de la carte
if (isValid($cb, $validite, $crypto)) {
    header("Location: validation.php?direction=acquittement.php&commande=" . $commande);
    exit;
} else {
    header("Location: cb.php?error&commande=" . $commande);
    exit;
}
?>
