<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("func/compte_inc.php");
include("func/commande_inc.php");
include("inc/top.php");
include("inc/bottom.php");

// Sécurisation de l'entrée
$commandeId = isset($_GET['commande']) ? intval($_GET['commande']) : 0;
$payee = isset($_GET['payee']);

// Obtention des informations nécessaires depuis la base de données
$statutCommande = statutCommande($bdd, $commandeId);
$identiteClient = getIdentite($bdd, $commandeId);

// Préparation de la requête pour éviter les injections SQL
$sql = "SELECT * FROM detailcommande, produit WHERE detailcommande.idproduit = produit.idproduit AND idcde = ?";
$stmt = $bdd->prepare($sql);
$stmt->execute([$commandeId]);
$montanttotal = 0;
?>

<div class="well well-small">
    <h1>Commande <small class="pull-right"> numéro <?php echo htmlspecialchars($commandeId); ?> (<?php echo htmlspecialchars($statutCommande); ?>)</small></h1>
    <hr class="soften"/>	
    <h3><b>Client : </b><?php echo htmlspecialchars($identiteClient); ?></h3>
    <hr class="soften"/>	
    <?php if($payee) {echo "<h3>Votre commande a bien été payée !</h3><hr class=\"soften\"/>"; }?>
    <table class="table table-bordered table-condensed">
        <thead>
            <tr>
                <th>Produit</th>
                <th>Description</th>
                <th>Ref.</th>
                <th>Prix Unitaire</th>
                <th>Qté </th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            while ($donnees = $stmt->fetch()){
                $montanttotal += $donnees['prix'] * $donnees['qte'];
            ?>
                <tr>
                    <td><img width="100" src="images/<?php echo htmlspecialchars($donnees['idproduit']); ?>.jpg" alt=""></td>
                    <td><b><?php echo htmlspecialchars($donnees['titre']); ?></b><br><?php echo htmlspecialchars($donnees['description']); ?></td>
                    <td>000<?php echo htmlspecialchars($donnees['idproduit']); ?></td>
                    <td><?php echo htmlspecialchars($donnees['prix']); ?> &euro;</td>
                    <td><?php echo htmlspecialchars($donnees['qte']); ?></td>
                    <td><?php echo htmlspecialchars($donnees['prix'] * $donnees['qte']); ?> &euro;</td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="5" class="alignR">Total:</td>
                <td class="label label-primary"> <?php echo $montanttotal; ?> &euro;</td>
            </tr>
        </tbody>
    </table><br/>

    <a href="mescommandes.php" class="shopBtn btn-large"><span class="icon-arrow-left"></span> Retour à la liste de mes commandes </a>
</div>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->
