<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("inc/bottom.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("inc/top.php");

// Redirection si l'utilisateur est déjà connecté
if(isset($_SESSION['iduser'])){
    header("Location: accueil.php");
    exit;
}

$infomsg = "";

// Traitement du formulaire de connexion
if(isset($_GET['connecter'])){
    // Préparation de la requête pour éviter les injections SQL
    $sql = "SELECT * FROM compte WHERE identifiant = ? AND password = ? LIMIT 1";
    $stmt = $bdd->prepare($sql);
    $stmt->execute([$_GET['identifiant'], $_GET['password']]);
    $donnees = $stmt->fetch();

    if($donnees){
        // Si l'utilisateur est trouvé, enregistrement des infos dans la session
        $_SESSION['nom'] = $donnees['nom'];
        $_SESSION['iduser'] = $donnees['id'];
        $_SESSION['prenom'] = $donnees['prenom'];       
        $_SESSION['identifiant'] = $donnees['identifiant'];
        $_SESSION['password'] = $donnees['password'];
        header("Location: accueil.php");
        exit;
    } else {
        $infomsg = "Erreur de connexion";
    }
}

?>

<form class="form-horizontal" action="connecter.php" method="get">
    <h3>&nbsp; Mon compte</h3>
    <?php if($infomsg): ?>
        <div class="control-group">
            <label class="control-label" for="inputFname"><?php echo htmlspecialchars($infomsg); ?></label>
        </div>
    <?php endif; ?>

    <div class="control-group">
        <label class="control-label" for="inputEmail">Identifiant <sup>*</sup></label>
        <div class="controls">
            <input type="text" name="identifiant" placeholder="votre Email">
        </div>
    </div>  
    <div class="control-group">
        <label class="control-label">Mot de passe <sup>*</sup></label>
        <div class="controls">
            <input type="password" name="password" placeholder="votre mot de passe">
        </div>
    </div>

    <div class="control-group">
        <div class="controls">
            <input type="submit" name="connecter" value="Me connecter" class="exclusive shopBtn">
        </div>
    </div>
</form>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->