<?php
session_start();
include("admin/config/bdd_config.inc");
include("admin/inc/bdd_connect.php");
include("inc/utils.php");
include("func/categorie_inc.php");
include("func/produit_inc.php");
include("func/panier_inc.php");
include("func/compte_inc.php");
include("inc/top.php");
include("inc/bottom.php");

if (isset($_SESSION['iduser'])) {
    if (isset($_POST['update'])) {
        // Utilisation des requêtes préparées pour éviter les injections SQL
        $sql = "UPDATE compte SET nom=?, prenom=?, identifiant=?, password=?, adresse=?, statut=? WHERE id=?";
        $stmt = $bdd->prepare($sql);
        $reponse = $stmt->execute([
            $_POST['nom'],
            $_POST['prenom'],
            $_POST['identifiant'],
            $_POST['password'],
            $_POST['adresse'],
            $_POST['statut'],
            $_SESSION['iduser']
        ]);

        if ($reponse) {
            $infomsg = "<font color=\"green\">Compte modifié</font>";

            // Mise à jour des informations en session
            $_SESSION['nom'] = $_POST['nom'];
            $_SESSION['prenom'] = $_POST['prenom'];       
            $_SESSION['identifiant'] = $_POST['identifiant'];
            $_SESSION['password'] = $_POST['password'];
            
            // Traitement de l'upload de la photo
            if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
                $allowedExtensions = ['jpg', 'jpeg', 'png']; // Extensions autorisées
                $path_parts = pathinfo($_FILES['photo']['name']);
                $extension = strtolower($path_parts['extension']);

                if (in_array($extension, $allowedExtensions)) {
                    $nomdestination = 'images/comptes/'.$_SESSION['iduser'].'.'.$extension;
                    move_uploaded_file($_FILES['photo']['tmp_name'], $nomdestination);
                }
            } 
        } else {
            $infomsg = "<font color=\"red\">Erreur lors de la mise à jour</font>";
        }
    }
} else {
    header("Location: connecter.php");
    exit;
}

?>

<form class="form-horizontal" action="mesinfos.php" method="post" enctype="multipart/form-data">
    <h3>&nbsp; Mes infos</h3>
    <?php if(isset($infomsg)) {
        echo "<div class=\"control-group\"><label class=\"control-label\" for=\"inputFname\">".$infomsg."</label></div>";
    } ?>
    <!-- Champs du formulaire -->
    <div class="control-group">
        <label class="control-label" for="inputFname">Nom<sup>*</sup></label>
        <div class="controls">
            <input type="text" name="nom" value="<?php echo htmlspecialchars($_SESSION['nom'] ?? ''); ?>" placeholder="votre nom">
        </div>
    </div>
    <!-- Autres champs... -->
    <div class="control-group">
        <div class="controls">
            <input type="submit" name="update" value="Mettre à jour" class="exclusive shopBtn">
        </div>
    </div>
</form>
</div>

<!-- Ici devrait se trouver le contenu du fichier "inc/bottom.php" -->

